/*
 * Copyright (c) 2010-2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * NXP Confidential. 
 * 
 * This software is owned or controlled by NXP and may only be used strictly 
 * in accordance with the applicable license terms.  By expressly accepting 
 * such terms or by downloading, installing, activating and/or otherwise 
 * using the software, you are agreeing that you have read, and that you 
 * agree to comply with and are bound by, such license terms. 
 * If you do not agree to be bound by the applicable license terms, 
 * then you may not retain, install, activate or otherwise use the software.
 */
#include "common.h"
#include "defines.h"
#include "fsl_qtmr.h"
#include "fsl_lptmr.h"
#include "fsl_adc16.h"
#include "math.h"
#include "Application.h"
#include "MeteringLPRT.h"
#include "Calibration1Ph.h"
#include "MeteringInterface1Ph.h"
#include "AppCommon.h"
#include "Fundamental1Ph.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define TMR2callback                             TMR2_IRQHandler
#define DoPulsing1Ph                             LPTMR0_LPTMR1_IRQHandler
/*******************************************************************************
* Prototypes
******************************************************************************/
uint8  OnActCounts;
uint8  OnReactCounts;
uint8  NumFreqCycles;
uint8  OnReactCounts;
uint16 LastTmrVal;  
uint16 ThisTmrVal;
uint32 FreqAccumPer;

uint8  ReactSampleIndex;
uint16 nSamps;

/*******************************************************************************
 * Code
 ******************************************************************************/
/*!
 * @brief This timer callback function accumates the active(and reactive if required)
 * energies calculated fron each metering cycle(1 sec) and compares the cumulative 
 * value with a threshold. If it exceeds the threshold value, turns on the 
 * LED for a duration. In electonic merters, this pulse is equivalent to 
 * 1 cycle rotation of disc in older electro-mechanical energy meters.
 */
void DoPulsing1Ph(void)
{
  LPTMR_ClearStatusFlags(LPTMR0, kLPTMR_TimerCompareFlag);
  /* Pulsing */
  ActAccumulator   += mlib1phdata.MetEnergyCounts[0];
  if (ActAccumulator >= CALIBLED_COMPARE)
  {
    ActAccumulator -= CALIBLED_COMPARE;
    ON_KWH_LED;
    OnActCounts = ONCOUNTS;
  }
  if (OnActCounts > 0)
  {
    OnActCounts--;
  }
  else
  {
    OFF_KWH_LED;
  }

#if 0
  ReactAccumulator   += mlib1phdata.MetEnergyCounts[1];
  if (ReactAccumulator >= CALIBLED_COMPARE)
  {
    ReactAccumulator -= CALIBLED_COMPARE;
    ON_KVARH_LED;
    OnReactCounts = ONCOUNTS;
  }
  if (OnReactCounts > 0)
  {
    OnReactCounts--;
  }
  else
  {
    OFF_KVARH_LED;
  }
#endif
}

#if 0
void InitRMSSums(void)
{
  uint8 i;
  for (i = 0; i < nVPHASES; i++)
  {
    VrmsSums[mlib3phdata.WBuffer][i] = 0;
  }
  for (i = 0; i < nIPHASES; i++)
  {
    IrmsSums[mlib3phdata.WBuffer][i] = 0;
  }
}
#endif

/*!
 * @brief Implements the ISR callback function of AFE channel for phase voltage 
 * measurement. This function sums up the square values of the voltage ADC samples 
 * after substracting from an average DC offset in the channel. It also accumulates 
 * the active power = voltage x current samples for phase/neutral channels.
 */
void V_Callback(void)
{
  int32 afeData;
  
  /* Phase current */
  afeData = PHASE_CURRENT_AFE_CH_RR;
  mlib1phdata.IOfstSum[0] += afeData;
  mlib1phdata.ISamps[0] = afeData - mlib1phdata.IOffsets[0]; // Previous offset
  if (pmlib1phdata->DoFundamental)
  {
    ISinSum1Ph[mlib1phdata.WBuffer][0] += (int64)((int64)afeData * (int64)SinTable[pmlib1phdata->fSampNo]);
    ICosSum1Ph[mlib1phdata.WBuffer][0] += (int64)((int64)afeData * (int64)CosTable[pmlib1phdata->fSampNo]);
  }

  /* Neutral current */
  afeData = NEUTRAL_CURRENT_AFE_CH_RR;
  mlib1phdata.IOfstSum[1] += afeData;
  mlib1phdata.ISamps[1] = afeData - mlib1phdata.IOffsets[1]; // Previous offset
  
  if (pmlib1phdata->DoFundamental)
  {
    ISinSum1Ph[mlib1phdata.WBuffer][1] += (int64)((int64)afeData * (int64)SinTable[pmlib1phdata->fSampNo]);
    ICosSum1Ph[mlib1phdata.WBuffer][1] += (int64)((int64)afeData * (int64)CosTable[pmlib1phdata->fSampNo]);
  }
  
  afeData = VOLTAGE_AFE_CH_RR;
  mlib1phdata.VOfstSum += afeData;
  mlib1phdata.VSampsS = afeData - mlib1phdata.VOffset; // Previous offset
  
  if (pmlib1phdata->DoFundamental)
  {
    VSinSum1Ph[mlib1phdata.WBuffer] += (int64)((int64)afeData * (int64)SinTable[pmlib1phdata->fSampNo]);
    VCosSum1Ph[mlib1phdata.WBuffer] += (int64)((int64)afeData * (int64)CosTable[pmlib1phdata->fSampNo]);
  }
  
  DoPower1Ph();
  SDK_ISR_EXIT_BARRIER;  
}

/*!
 * @brief This timer callback function calculates the frequency of the meter.
 */
void TMR2callback(void)
{
  uint16 TmrCounts;
  float freq;
  
  /* Clear interrupt flag.*/
  QTMR_ClearStatusFlags(TMR2, kQTMR_EdgeFlag);
  /* If valid period, accumulate for 50 cycles */
  /* Read TMR Count Value */
  ThisTmrVal = QTMR_GetCurrentTimerCount(TMR2);
  TmrCounts = 0x10000 + ThisTmrVal - LastTmrVal;
  LastTmrVal = ThisTmrVal;
  FreqAccumPer += TmrCounts;
  
  if (TmrCounts > 10000)
  {
    NumFreqCycles++;
#if 0
    if (CntsForOfst >= 250)
    {
      DoOffsets();
    }
#endif
  }

  /* If period accumulation cycles crossed */
  if (NumFreqCycles >= PERIOD_ACCUMULATION_CYCLES)
  {
    /* Time to compute frequency */
    freq = (float)FreqAccumPer/NumFreqCycles;

    NumFreqCycles = 0;
    FreqAccumPer = 0;
    
    /* Frequency conversion to real value */
    freq = (TMR_CNTS_50HZ/freq)*50.0;
    mlib1phdata.Frequency = freq * CalibStruct1Ph.FrequencyCoeff;
  }
  SDK_ISR_EXIT_BARRIER;
}

void TMR2callbackND(void)
{
  uint16 TmrCounts;
  float freq;

  /* Clear interrupt flag.*/
  QTMR_ClearStatusFlags(TMR2, kQTMR_EdgeFlag);

  /* If valid period, accumulate for 50 cycles */
  /* Read TMR Count Value */
  ThisTmrVal = QTMR_GetCurrentTimerCount(TMR2);
  TmrCounts = 0x10000 + ThisTmrVal - LastTmrVal;
  LastTmrVal = ThisTmrVal;
  FreqAccumPer += TmrCounts;
  
  if (TmrCounts > 4000)
  {
    NumFreqCycles++;
  }

  /* If period accumulation cycles crossed */
  if (NumFreqCycles >= PERIOD_ACCUMULATION_CYCLES)
  {
    /* Time to compute frequency */
    freq = (float)FreqAccumPer/NumFreqCycles;

    NumFreqCycles = 0;
    FreqAccumPer = 0;
    
    /* Frequency conversion to real value */
    freq = (TMR_CNTS_50HZ_ND/freq)*50.0;
    mlib1phdata.Frequency = freq * CalibStruct1Ph.FrequencyCoeff;
  }
  SDK_ISR_EXIT_BARRIER;
}
